<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Services;
use Faker\Factory as Faker;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create();

        $services = [
            'Registration',
            'Insurance',
            'Loans',
            'Application Form',
            'Annual Returns',
            'Membership Renewal',
            'Farmers Trainings',
            'SMEs Training',
            'Tailor Made Programs',
            'Application Forms',
        ];

        foreach ($services as $service) {
            Services::create([
                'name' => $service,
                'description' => $faker->sentence,
                'price' => $faker->numberBetween(100, 10000), // Random price in Kwacha
            ]);
        }
    }
}
