<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'transaction_id',
        'user_name',
        'user_phone',
        'total_amount',
        'status',
        'payment_method',
        'mobile_money_phone',
        'card_holder_name',
        'card_last_four',
        'payment_details',
    ];

    protected $casts = [
        'total_amount' => 'decimal:2',
        'payment_details' => 'array',
    ];

    public function services()
    {
        return $this->belongsToMany(Services::class, 'service_transaction', 'transaction_id', 'service_id')
                    ->withPivot('price')
                    ->withTimestamps();
    }

    public function getPaymentMethodDisplayAttribute()
    {
        return match($this->payment_method) {
            'mobile_money' => 'Mobile Money',
            'card' => 'Credit/Debit Card',
            'bank_transfer' => 'Bank Transfer',
            default => ucfirst(str_replace('_', ' ', $this->payment_method))
        };
    }
}
