<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Services;

class CartController extends Controller
{
    public function index()
    {
        $cart = session('cart', []);
        $services = Services::whereIn('id', $cart)->get();
        $total = $services->sum('price');

        return view('cart.index', compact('services', 'total', 'cart'));
    }

    public function clear()
    {
        session()->forget('cart');
        return redirect()->back()->with('message', 'Cart cleared successfully!');
    }

    public function remove(Services $service)
    {
        $cart = session('cart', []);

        if (($key = array_search($service->id, $cart)) !== false) {
            unset($cart[$key]);
        }

        session(['cart' => $cart]);

        return redirect()->back()->with('message', 'Item removed from cart successfully!');
    }
}
