<?php

namespace App\Filament\Widgets;

use App\Models\Services;
use App\Models\Transaction;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected function getStats(): array
    {
        $totalRevenue = Transaction::where('status', 'completed')->sum('total_amount');
        $totalTransactions = Transaction::where('status', 'completed')->count();
        $totalServices = Services::where('status', 'active')->count();
        $pendingTransactions = Transaction::where('status', 'pending')->count();

        return [
            Stat::make('Total Revenue', 'ZMW' . number_format($totalRevenue, 2))
                ->description('From completed transactions')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color('success'),
            
            Stat::make('Completed Transactions', $totalTransactions)
                ->description('Successfully processed')
                ->descriptionIcon('heroicon-m-check-circle')
                ->color('success'),
            
            Stat::make('Active Services', $totalServices)
                ->description('Available for purchase')
                ->descriptionIcon('heroicon-m-cog-6-tooth')
                ->color('info'),
            
            Stat::make('Pending Transactions', $pendingTransactions)
                ->description('Awaiting processing')
                ->descriptionIcon('heroicon-m-clock')
                ->color('warning'),
        ];
    }
}