<?php

namespace App\Filament\Resources;

use App\Filament\Resources\LoanResource\Pages;
use App\Models\Loan;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class LoanResource extends Resource
{
    protected static ?string $model = Loan::class;

    protected static ?string $navigationIcon = 'heroicon-o-currency-dollar';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('amount')
                    ->label('Loan Amount')
                    ->numeric()
                    ->required(),
                Forms\Components\TextInput::make('interest_rate')
                    ->label('Interest Rate (%)')
                    ->numeric()
                    ->required(),
                Forms\Components\TextInput::make('duration_months')
                    ->label('Duration (Months)')
                    ->numeric()
                    ->required(),
                Forms\Components\Select::make('status')
                    ->label('Status')
                    ->options([
                        'pending' => 'Pending',
                        'approved' => 'Approved',
                        'rejected' => 'Rejected',
                        'paid' => 'Paid',
                    ])
                    ->required(),
                Forms\Components\DatePicker::make('approved_at')
                    ->label('Approval Date')
                    ->nullable(),
                Forms\Components\DatePicker::make('disbursed_at')
                    ->label('Disbursement Date')
                    ->nullable(),
                Forms\Components\DatePicker::make('due_date')
                    ->label('Due Date')
                    ->nullable(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')->label('ID')->sortable(),
                Tables\Columns\TextColumn::make('amount')->label('Amount')->sortable(),
                Tables\Columns\TextColumn::make('interest_rate')->label('Interest Rate (%)'),
                Tables\Columns\TextColumn::make('duration_months')->label('Duration (Months)'),
                Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),
                Tables\Columns\TextColumn::make('approved_at')->label('Approved At')->dateTime(),
                Tables\Columns\TextColumn::make('disbursed_at')->label('Disbursed At')->dateTime(),
                Tables\Columns\TextColumn::make('due_date')->label('Due Date')->dateTime(),
                Tables\Columns\TextColumn::make('created_at')->label('Created At')->dateTime()->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLoans::route('/'),
            'create' => Pages\CreateLoan::route('/create'),
            'edit' => Pages\EditLoan::route('/{record}/edit'),
        ];
    }
}
